﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Ksiega" %>
<script runat="server">

	public class Params: ContextBase {
	
		public Params(Context context): base(context) {
			wymagalnoscElementuKsiegowalnegoOstrzezenie = KsiegaModule.GetInstance(context).Config.Ogólne.WymagalnośćElemKsięgOstrzeżenie;
		}

		bool wymagalnoscElementuKsiegowalnegoOstrzezenie = false;
		[Caption("Tylko ostrzeżenie")]
		public bool WymagalnoscElementuKsiegowalnegoOstrzezenie {
			get { return wymagalnoscElementuKsiegowalnegoOstrzezenie; }
			set {
				wymagalnoscElementuKsiegowalnegoOstrzezenie = value;
				OnChanged(EventArgs.Empty);
			}
		}
	}

	Params pars;
	[Context]
	public Params Pars {
		get { return pars; }
		set { pars = value; }
	}

    void dc_ContextLoad(Object sender, EventArgs e) {
			if (KsiegaModule.GetInstance(pars).Config.Ogólne.WymagalnośćElemKsięgOstrzeżenie
				== pars.WymagalnoscElementuKsiegowalnegoOstrzezenie)
				throw new Exception("Nie zmieniono ustawienia - identyczne z aktualnym");
			
			using (Session session = dc.Session.Login.CreateSession(false, true)) {
				using (ITransaction t = session.Logout(true)) {
					KsiegaModule.GetInstance(session).Config.Ogólne.WymagalnośćElemKsięgOstrzeżenie 
						= pars.WymagalnoscElementuKsiegowalnegoOstrzezenie;
					t.CommitUI();
				}
				session.Save();
			}
		
			throw new CancelException();
    }
    
	static void Msg(object value) {
	}
	
	static public string NazwaKategorii = "ksiega";
	static public string NazwaPola = "WymagalnoscElementuKsiegowalnegoOstrzezenie";	

</script>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Usuwanie podlegania rozliczeniom</title> 
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
	<meta content="C#" name="CODE_LANGUAGE">
	<meta content="JavaScript" name="vs_defaultClientScript">
	<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
</head>
<body>
    <form id="Form1" method="post" runat="server">
        <ea:DataContext id="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
    </form>
</body>
</html>
